<?php
$default_options = array(
    'maxwidth'             => '0',
    'lockheight'           => '1',
    'height'               => '500',
    'maxheight'            => '0',
    'imageZoom'            => 'FILL',
    'autoSlideshow'        => '1',
    'slideshowDelay'       => '10',
    'thumbHeight'          => '100',
    'descrVisOnMouseover'  => '1',
    'wmode'                => 'opaque',
    'bgColor'              => 'ffffff',
    'imagesBgColor'        => '000000',
    'barsBgColor'          => '000000',
    'catButtonColor'       => '75c30f',
    'catButtonColorHover'  => 'ffffff',
    'scrollBarTrackColor'  => '75c30f',
    'scrollBarButtonColor' => 'f1f1f1',
    'thumbBgColor'         => 'ffffff',
    'thumbLoaderColor'     => '75c30f',
    'imageTitleColor'      => '75c30f',
    'imageTitleFontSize'   => '14',
    'imageDescrColor'      => 'ffffff',
    'imageDescrFontSize'   => '12',
    'imageDescrBgColor'    => '000000',
    'imageDescrBgAlpha'    => '85',
    'customCSS'            => ''
);
$options_tree    = array(
    array(
        'label'  => 'Common Settings',
        'fields' => array(
            'maxwidth'            => array(
                'label' => 'Max-Width',
                'tag'   => 'input',
                'attr'  => 'type="number" min="0"',
                'text'  => 'By default gallery width always 100%. Set the maximum width of the gallery (in pixels). Leave 0 to disable max-width.'
            ),
            'lockheight'          => array(
                'label' => 'Set height manually',
                'tag'   => 'checkbox',
                'attr'  => 'data-watch="change"',
                'text'  => 'By default a gallery automatically calculates own height to best fit the tallest image in a gallery.'
            ),
            'height'              => array(
                'label' => 'Height',
                'tag'   => 'input',
                'attr'  => 'type="text" min="0" data-lockheight="is:1"',
                'text'  => 'Set height of the gallery. Do not set % unless you know what you doing.'
            ),
            'maxheight'           => array(
                'label' => 'Max-Height',
                'tag'   => 'input',
                'attr'  => 'type="number" min="0" data-lockheight="is:0"',
                'text'  => 'Set the maximum height of the gallery. Leave 0 to disable max-height.'
            ),
            'imageZoom'           => array(
                'label'   => 'Image Zoom',
                'tag'     => 'select',
                'attr'    => '',
                'text'    => 'Default value: Fill.',
                'choices' => array(
                    array(
                        'label' => 'Fill',
                        'value' => 'FILL'
                    ),
                    array(
                        'label' => 'Fit',
                        'value' => 'FIT'
                    )
                )
            ),
            'autoSlideshow'       => array(
                'label' => 'Automatic Slideshow (On/Off)',
                'tag'   => 'checkbox',
                'attr'  => '',
                'text'  => ''
            ),
            'slideshowDelay'      => array(
                'label' => 'Slideshow Delay',
                'tag'   => 'input',
                'attr'  => 'type="number" min="1" max="60"',
                'text'  => 'Set delay between slides in seconds'
            ),
            'thumbHeight'         => array(
                'label' => 'Thumbnails Height',
                'tag'   => 'input',
                'attr'  => 'type="number" min="0" max="300"',
                'text'  => 'Set bottom thumbnails row height in pixels'
            ),
            'descrVisOnMouseover' => array(
                'label' => 'Show Description',
                'tag'   => 'checkbox',
                'attr'  => '',
                'text'  => 'Show image description on mouseover'
            )
            /*,
            'hitcounter' => array(
                'label' => 'Count Image Views',
                'tag' => 'checkbox',
                'attr' => '',
                'text' => ''
            )*/
        )
    ),
    array(
        'label'  => 'Colors and Fonts',
        'fields' => array(
            'wmode'                => array(
                'label'   => 'Wmode for flash object',
                'tag'     => 'select',
                'attr'    => 'data-watch="change"',
                'text'    => 'Default value: Opaque. If \'transparent\' - "Background Color" option is ignored, but you can position the absolute elements over the flash',
                'choices' => array(
                    array(
                        'label' => 'Opaque',
                        'value' => 'opaque'
                    ),
                    array(
                        'label' => 'Window',
                        'value' => 'window'
                    ),
                    array(
                        'label' => 'Transparent',
                        'value' => 'transparent'
                    )
                )
            ),
            'bgColor'              => array(
                'label' => 'Background Color',
                'tag'   => 'input',
                'attr'  => 'type="text" data-type="color" data-wmode="not:transparent"',
                'text'  => 'Set gallery background color'
            ),
            'imagesBgColor'        => array(
                'label' => 'Images Background Color',
                'tag'   => 'input',
                'attr'  => 'type="text" data-type="color"',
                'text'  => 'Set loading images background color'
            ),
            'barsBgColor'          => array(
                'label' => 'Bars Background Color',
                'tag'   => 'input',
                'attr'  => 'type="text" data-type="color"',
                'text'  => 'Background color for Menu bar, Thumbnails bar and Scroll bar'
            ),
            'catButtonColor'       => array(
                'label' => 'Menu Bar Buttons Color',
                'tag'   => 'input',
                'attr'  => 'type="text" data-type="color"',
                'text'  => ''
            ),
            'catButtonColorHover'  => array(
                'label' => 'Menu Bar Buttons Color on Mouseover',
                'tag'   => 'input',
                'attr'  => 'type="text" data-type="color"',
                'text'  => ''
            ),
            'scrollBarTrackColor'  => array(
                'label' => 'Scroll Bar Track Color',
                'tag'   => 'input',
                'attr'  => 'type="text" data-type="color"',
                'text'  => ''
            ),
            'scrollBarButtonColor' => array(
                'label' => 'Scroll Bar Button Color',
                'tag'   => 'input',
                'attr'  => 'type="text" data-type="color"',
                'text'  => ''
            ),
            'thumbBgColor'         => array(
                'label' => 'Thumbnail BG Color',
                'tag'   => 'input',
                'attr'  => 'type="text" data-type="color"',
                'text'  => 'Background of the thumbnail placeholder while thumbnail is loading'
            ),
            'thumbLoaderColor'     => array(
                'label' => 'Thumbnail Loader Color',
                'tag'   => 'input',
                'attr'  => 'type="text" data-type="color"',
                'text'  => ''
            ),
            'imageTitleColor'      => array(
                'label' => 'Image Title Color',
                'tag'   => 'input',
                'attr'  => 'type="text" data-type="color"',
                'text'  => 'Color for image title text'
            ),
            'imageTitleFontSize'   => array(
                'label' => 'Image Title Font Size',
                'tag'   => 'input',
                'attr'  => 'type="number" min="10" max="30"',
                'text'  => ''
            ),
            'imageDescrColor'      => array(
                'label' => 'Image Description Color',
                'tag'   => 'input',
                'attr'  => 'type="text" data-type="color"',
                'text'  => 'Color for image description text'
            ),
            'imageDescrFontSize'   => array(
                'label' => 'Image Description Font Size',
                'tag'   => 'input',
                'attr'  => 'type="number" min="10" max="30"',
                'text'  => ''
            ),
            'imageDescrBgColor'    => array(
                'label' => 'Image Description BG Color',
                'tag'   => 'input',
                'attr'  => 'type="text" data-type="color"',
                'text'  => 'Background color for the description pane that appears on mouseover'
            ),
            'imageDescrBgAlpha'    => array(
                'label' => 'Image Description Background Alpha',
                'tag'   => 'input',
                'attr'  => 'type="number" min="0" max="100" step="5"',
                'text'  => 'Opacity of the description pane background'
            )
            /*,
            'backButtonTextColor' => array(
                'label' => 'Back Button Text Color',
                'tag' => 'input',
                'attr' => 'type="text" data-type="color"',
                'text' => '(only for Full Window template). Default: ffffff'
            ),
            'backButtonBgColor' => array(
                'label' => 'Back Button Background Color',
                'tag' => 'input',
                'attr' => 'type="text" data-type="color"',
                'desc'  => '(only for Full Window template). Default: 000000'
            )*/
        )
    ),
    array(
        'label'  => 'Advanced Settings',
        'fields' => array(
            'customCSS' => array(
                'label' => 'Custom CSS',
                'tag'   => 'textarea',
                'attr'  => 'cols="20" rows="10"',
                'text'  => 'You can enter custom style rules into this box if you\'d like. IE: <i>a{color: red !important;}</i><br />This is an advanced option! This is not recommended for users not fluent in CSS... but if you do know CSS, anything you add here will override the default styles'
            )
            /*,
            'loveLink' => array(
                'label' => 'Display LoveLink?',
                'tag' => 'checkbox',
                'attr' => '',
                'text' => 'Selecting "Yes" will show the lovelink icon (codeasily.com) somewhere on the gallery'
            )*/
        )
    )
);

