/*!****************************
 *                            *
 *  Smart Alert 1.0           *
 *                            *
 *  Code: Lukas Prvy          *
 *  Graphics: Pierre Borodin  *
 *                            *
 ******************************


Usage:

    $.alert.open([type], [title], content, [buttons], [callback]);

    or

    $.alert.open({settings});

Settings:

    container Container for alert placement (optional, 'body')
    type      Alert type('info', 'confirm', 'warning', 'error') (optional, 'info')
    title     Alert title (optional, default title for certain alert type)
    cancel    Show close icon(alert can be then closed also with ESC) (optional, true)
    icon      Set one of icons defined in theme stylesheet or hide icon by setting false (optional, 'info')
    content   Alert content (optional)
    align     Content alignment('left', 'center', 'right') (optional, 'left')
    buttons   Object with buttons {id: 'label', ...} (optional, default buttons for certain alert type or {ok: 'Ok'})
    width     Alert width (optional, 'auto')
    draggable Drag&drop(requires jQuery-UI)
    callback  Function that will be called after button press. Parameter value will be pressed
              button id or false in case of closing alert by click on close icon. (optional)
    pie       Determines whether to use PIE.htc directly or use its PHP wrapper('htc', 'php') (optional, 'htc')


Setup:

    $.alert.setup({settings});

Settings:

    defaults           Default alert settings
    defaults.container Default container for alert placement
    defaults.type      Default alert type('info', 'confirm', 'warning', 'error')
    defaults.cancel    Default cancelable setting
    defaults.icon      Default icon setting(icon name or false)
    defaults.content   Default alert content
    defaults.align     Default content alignment('left', 'center', 'right')
    defaults.buttons   Default object with buttons {id: 'label', ...}
    defaults.width     Default alert width
    defaults.draggable Default drag&drop setting
    defaults.callback  Default callback
    defaults.pie       Use PIE.htc directly or use its PHP wrapper('htc', 'php') default setting
    types              Alert types {'typename': {settings}, ...} (optional)

*/

(function(f){var e={defaults:{container:"body",type:"info",title:"&nbsp;",cancel:true,icon:"info",content:"&nbsp;",align:"left",buttons:{ok:"Ok"},width:"auto",draggable:true,callback:f.noop,pie:"htc"},types:{info:{title:"Info",icon:"info",buttons:{ok:"Ok"}},confirm:{title:"Confirm",icon:"confirm",buttons:{yes:"Yes",no:"No"}},warning:{title:"Warning",icon:"warning",buttons:{ok:"Ok"}},error:{title:"Error",icon:"error",buttons:{ok:"Ok"}}}};var d={};var g=false;var l=f([]);var b=f([]);function h(){var n=["close.png","info.png","confirm.png","warning.png","error.png"];var o=window.devicePixelRatio&&devicePixelRatio==2;n=f.map(n,function(r){return(o?"x2":"img")+"/"+r});var p=f('link[href*="alert/themes/"]');if(!p.length){return}var q=p.attr("href");q=q.substr(0,q.lastIndexOf("/")+1);f.each(n,function(t,s){var r=f("<img />").attr("src",q+s)})}function m(){var o={};if(arguments.length){if(f.isPlainObject(arguments[0])){o=arguments[0]}else{var n=Array.prototype.slice.call(arguments);if(f.isFunction(n[n.length-1])){o.callback=n.pop()}if(f.isPlainObject(n[n.length-1])){o.buttons=n.pop()}if(n.length==3){o.type=n[0];o.title=n[1];o.content=n[2]}else{if(n.length==2){if(e.types[n[0]]){o.type=n[0]}else{o.title=n[0]}o.content=n[1]}else{o.content=n[0]}}}}if(!e.types[o.type]){o.type=e.defaults.type}o=f.extend({},e.defaults,e.types[o.type],o);if(typeof f.fn.draggable=="undefined"){o.draggable=false}o.title=f.trim(o.title)||e.types[o.type].title;return o}function c(){var o=[];f.each(d.buttons,function(q,p){o.push(["<div",'    class="smartAlertButton"','    data-id="'+q+'"',">",p,"</div>"].join(""))});var n=parseInt(f.browser.version);f(["<div",'    id="smartAlert"','    data-type="'+d.type+'"','    data-cancel="'+d.cancel+'"','    data-icon="'+d.icon+'"','    data-align="'+d.align+'"','    data-draggable="'+d.draggable+'"','    data-pie="'+d.pie+'"',f.browser.chrome?'data-chrome="'+n+'"':"",f.browser.webkit?'data-webkit="'+n+'"':"",f.browser.mozilla?'data-mozilla="'+n+'"':"",f.browser.opera?'data-opera="'+n+'"':"",f.browser.msie?'data-ie="'+n+'"':"",">",'    <div id="smartAlertBox">','        <div id="smartAlertHeader">','            <div id="smartAlertTitle">',d.title,"            </div>",'            <div id="smartAlertClose"></div>',"        </div>",f.browser.msie&&n==7?['        <table id="smartAlertBody">',"            <tbody>","                <tr>",'                    <td id="smartAlertIcon"></td>',"                    <td>",'                        <div id="smartAlertContent">',d.content,"                        </div>","                    </td>","                </tr>","            </tbody>","        </table>"].join(""):['        <div id="smartAlertBody">','            <div id="smartAlertIcon"></div>','            <div id="smartAlertContent">',d.content,"            </div>","        </div>"].join(""),'        <div id="smartAlertButtons">',o.join(""),"        </div>","    </div>","</div>"].join("")).appendTo(d.container);l=f("#smartAlert");b=f("#smartAlertBox");b.width(d.width)}function a(){b.css({top:Math.round(l.height()/2-b.outerHeight()/2-parseInt(b.css("margin-top"))),left:Math.round(l.width()/2-b.outerWidth()/2-parseInt(b.css("margin-left")))})}function k(n){if(!g){return}l.stop(true,true).fadeOut(250,function(){l.remove();g=false;if(f.isFunction(n)){n()}else{d.callback(n||false)}})}function j(){if(!(f.browser.msie&&f.browser.version<=9)){return}var o=f('link[href*="alert/css/"]');var n=o.attr("href");n=n.substr(0,n.lastIndexOf("/")+1);f("*",l).each(function(){var p=f(this);if(p.css("behavior")!="none"){if(f.browser.version<9){p.css("behavior","none")}p.css("behavior","url("+n+"PIE."+d.pie+")")}})}function i(){h();f(document).on("keydown",function(n){if(n.which==27&&d.cancel){k()}}).on("click","#smartAlertClose",function(){k()}).on({mousedown:function(){f(this).addClass("smartAlertClick")},"mouseup mouseleave":function(){f(this).removeClass("smartAlertClick")},click:function(){k(f(this).data("id"))}},".smartAlertButton");f(window).on("resize",function(){if(g&&f(d.container).is("body")){a()}})}jQuery.alert={open:function(){var o=arguments;function n(){d=m.apply(null,o);c();a();if(d.draggable){b.draggable({containment:"#smartAlert",handle:"#smartAlertHeader"})}l.css({display:"none",visibility:"visible"}).fadeIn(250);j();g=true}if(g){k(n)}else{n()}},setup:function(n){if(f.isPlainObject(n)){f.extend(true,e,n)}return f.extend(true,{},e)}};f(i)})(jQuery);